% batchAnalyzeVideo.m
%
% This is a batch script which goes through the provided directory and
% analyzes each .avi file present.  It then plots the average fluorescence
% changes with the standard error.

% PARAMETERS
lw = 2;  % LineWidth of plot

bluegray = [0.8 0.8 1];  % Color for error shading

tmpAviFiles = struct('name', {}, 'date', {}, 'bytes', {}, 'isdir', {}, 'datenum', {});


folderName = input('Enter a directory (w/o final /) filled with imaging videos: ', 's');
numROI = input('Number of ROI per video: ');
labels = input('Labels for legend (in format {label1, label2, etc.}): ');

aviFiles = dir(folderName);
for aviNum=1:numel(aviFiles)  % Filter out filenames that match annotated video names
    if (~isempty(regexp(aviFiles(aviNum).name, '.avi', 'once')))
        tmpAviFiles(end+1) = aviFiles(aviNum);
    end
end
aviFiles = tmpAviFiles;

if (numel(aviFiles) == 0)
    error('No videos in that directory!');
end

vid = VideoReader(strcat(folderName, filesep, aviFiles(1).name));

% MASTER RESULT VARIABLE - Assumes all videos have same number of frames
f = zeros(numel(aviFiles), vid.NumberOfFrames, numROI);

for i = 1:numel(aviFiles)
    f(:,i) = analyzeVideo(strcat(folderName, filesep, aviFiles(i).name), labels);
end

fm = mean(f);
fstd = std(f);
fsem = fstd / sqrt(size(f, 1));

% Plot average +- sem
figure
hold on
x = (1:vid.NumberOfFrames)/vid.FrameRate;
for i=1:numROI
    y = fm(:,:,i);
    err = fsem(:,:,i);
    patch([x fliplr(x)], [y+err fliplr(y-err)], bluegray, 'EdgeColor', 'none');
    plot(x,y, 'LineWidth', lw);
end

yl = ylim();
ylim([-.1 yl(2)]);
legend(labels);
title('\DeltaF / F', 'FontWeight', 'bold');
xlabel('time (sec)', 'FontWeight', 'bold');
ylabel('\DeltaF / F (%)', 'FontWeight', 'bold');
prettify();

